/*
    Aware.c -- Version 3.0 
    by Mark Day
    
    Developer Technical Support Apple II Sample Code

    Copyright (c) 1990 by Apple Computer, Inc.
    All Rights Reserved.

    This is a very simple program that shows how to use the "@" prefix
    and class 1 Open to be network aware.  When it starts up, it gets
    the date/time it was last run from a configuration file.  When it
    quits, it updates that last run time in the configuration file.
    There are menu items to allow you to force the configuration to be
    loaded and saved.  The last run time is displayed as part of the
    about box.
    
    The "@" prefix is the name of the directory where configuration
    information can be stored.  Its actual contents depend on where
    the application was launched from.  If it was launched from a
    non-AppleShare disk, it will be set to the directory containing
    the application (the same as prefix "1").  If it was launched
    from an AppleShare disk, it will be set to that user's folder on
    the user volume of the file server (if there is no user volume
    online, it will revert to the directory containing the application).
    
    This method is useful for saving configuration information, defaults,
    or preferences on a per-user name basis.  Note that if several people
    are logged on to the same server as the same user name, and launch
    the application from a server, they will all access the same
    configuration file (even though you use the "@" prefix).  It is up
    to the users to log on with different names if they want to
    personalize their configuration/defaults/preferences.
*/

#include <types.h>          /* {CIIGSIncludes}types.h */
#include <quickdraw.h>      /* {CIIGSIncludes}quickdraw.h */
#include <locator.h>        /* {CIIGSIncludes}locator.h */

/*
    Here is the main program.  It's really pretty simple.  It
    starts up the tools, creates the menus, loads the configuration
    data, puts up the about box, and falls into the main event loop.
*/
main()
{
    Ref     initRef;        /* This holds the reference to the startstop record */

    /*  Note: StartUpTools starts up the resource manager and opens
        the application's resource fork as read-only.  This is the
        safe, network aware way to do it.  You can always open it for
        read/write yourself, but at the expense of extra code and not
        being network aware. */
        
    /* Startup the tools using the new toolbox call */
    initRef = StartUpTools(_ownerid, refIsResource, 0x0001L);

    /* Remember, (!_toolErr) means (if no error returned by the tool) */
    if (!_toolErr) {
    
        /* Init the menus, the cursor, and global variables. */
        setupMenus();       /* Set up menus */
        InitCursor();       /* Make cursor show ready */
        InitGlobals();      /* Set up global variables */
        
        /*  Here, load the configuration information for this user.
            This is done now so that it is available for the about
            box which is displayed at startup. */
        
        loadConfig();       /* Load configuration options */
        doAboutItem();      /* Put up the about box */
        
        mainEvent();        /* Use application */
    }

    /*  The user has quit the application (or it couldn't start
        up the tools properly), so shut down the tools and exit. */
    ShutDownTools(refIsHandle, initRef);
}
